/****************************************************/
/****** http://fabien.goy.free.fr/FormulaCalc/ ******/
/****************************************************/




function showPrefs()
{
    var front = document.getElementById("front");
    var back = document.getElementById("behind");
        
    if (window.widget)
        widget.prepareForTransition("ToBack");
                
    front.style.display="none";
    back.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);  
}

function hidePrefs()
{

    SetModeAngle();

    var front = document.getElementById("front");
    var back = document.getElementById("behind");
        
    if (window.widget)
        widget.prepareForTransition("ToFront");
                
    back.style.display="none";
    front.style.display="block";
        
    if (window.widget)
        setTimeout ('widget.performTransition();', 0);
        
    exitflip();
}


function enterflip(event)
{
	document.getElementById('fliprollie').style.display = 'block';
}

function exitflip(event)
{
	document.getElementById('fliprollie').style.display = 'none';
}


/************************/
/*    Flip Functions    */
/************************/

var flipShown = false;
var animation = {duration:0, starttime:0, to:1.0, now:0.0, from:0.0, firstElement:null, timer:null};
function mousemove (event)
{
    if (!flipShown)
    {
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 1.0;
        animate();
        flipShown = true;
    }
}



function mouseexit (event)
{
    if (flipShown)
    {
        // fade in the info button
        if (animation.timer != null)
        {
            clearInterval (animation.timer);
            animation.timer  = null;
        }
                
        var starttime = (new Date).getTime() - 13;
                
        animation.duration = 500;
        animation.starttime = starttime;
        animation.firstElement = document.getElementById ('flip');
        animation.timer = setInterval ("animate();", 13);
        animation.from = animation.now;
        animation.to = 0.0;
        animate();
        flipShown = false;
    }
}



function animate()
{
    var T;
    var ease;
    var time = (new Date).getTime();
                
        
    T = limit_3(time-animation.starttime, 0, animation.duration);
        
    if (T >= animation.duration)
    {
        clearInterval (animation.timer);
        animation.timer = null;
        animation.now = animation.to;
    }
    else
    {
        ease = 0.5 - (0.5 * Math.cos(Math.PI * T / animation.duration));
        animation.now = computeNextFloat (animation.from, animation.to, ease);
    }
        
    animation.firstElement.style.opacity = animation.now;
}


function limit_3 (a, b, c)
{
    return a < b ? b : (a > c ? c : a);
}


function computeNextFloat (from, to, ease)
{
    return from + (to - from) * ease;
}


function doneClicked() {
        var front = document.getElementById("front");
        var back = document.getElementById("behind");

        if (window.widget)
                widget.prepareForTransition("ToFront");


        front.style.display="block";
        back.style.display="none";

        setTimeout ('flipitback();', 0);
}






/************************/
/*    Math Functions    */
/************************/

var pi=Math.PI;

var e=exp(1);

function fact(n) {
    if(n==0) { return 1 }
    if(n<0) { if(n> -1) { return Fact(n+1)/(n+1)} { return -pi/( fact(-1-n) * sin(pi*n))} }
    if((n%1)==0) { var r=n; while(n>1) { n=n-1; r=r*n } }
        else { var r=exp((n+0.5)*ln(n+1)-n-n*(0.1121105+n*0.08106103)/(1.452342+n*(2.410858+n))) }
    return r
    }
function gamma(n) { return fact(n-1) }
function abs(x) { return Math.abs(x) }
function sqrt(x) { return Math.sqrt(x) }
function exp(x) { return Math.exp(x) }
function ln(x) { return Math.log(x) }
function log10(x) { return Math.log(x)/Math.log(10) }
function log2(x) { return Math.log(x)/Math.log(2) }
function pow(x,y) { return Math.pow(x,y) }
function sin(x) { return Math.sin(x*DEGREE) }
function cos(x) { return Math.cos(x*DEGREE) }
function tan(x) { return Math.sin(x*DEGREE)/Math.cos(x*DEGREE) }
function cot(x) { return Math.cos(x*DEGREE)/Math.sin(x*DEGREE) }
function sec(x) { return 1/Math.cos(x*DEGREE) }
function csc(x) { return 1/Math.sin(x*DEGREE) }
function atan(x) { return Math.atan(x*DEGREE) }
function asin(x) { return Math.asin(x*DEGREE) }
function acos(x) { return Math.acos(x*DEGREE) }
function acot(x) { return ATan(1/(x*DEGREE)) }
function asec(x) { return ACos(1/(x*DEGREE)) }
function acsc(x) { return ASin(1/(x*DEGREE)) }

function sinh(x) { return (Math.exp(x*DEGREE)-Math.exp(-x*DEGREE))/2 }
function cosh(x) { return (Math.exp(x*DEGREE)+Math.exp(-x*DEGREE))/2 }
function tanh(x) { return SinH(x*DEGREE)/CosH(x*DEGREE) }
function coth(x) { return 1/TanH(x*DEGREE) }
function sech(x) { return 1/CosH(x*DEGREE) }
function csch(x) { return 1/SinH(x*DEGREE) }
function asinh(x) { return Math.log(x+Math.sqrt(x*DEGREE*x*DEGREE+1)) }
function acosh(x) { return Math.log(x+Math.sqrt(x*DEGREE*x*DEGREE-1)) }
function atanh(x) { return 0.5*Math.log((1+x*DEGREE)/(1-x*DEGREE)) }
function acoth(x) { return 0.5*Math.log((x*DEGREE+1)/(x*DEGREE-1)) }
function asech(x) { return Math.log(1/x+Math.sqrt(1/(x*DEGREE*x*DEGREE)+1)) }
function acsch(x) { return Math.log(1/x+Math.sqrt(1/(x*DEGREE*x*DEGREE)-1)) }




function CalcExpr(formula) {
	var calc = formula;    // recupere la valeur du champ formula
	var res = document.getElementById('result-text');  // recupere le handle sur le champ de resultat
    var formule = document.getElementById('formula-text');  // recupere le handle sur le champ de resultat


	/**** remplace , par . ****/
	var re = /,/gi;
    calc = calc.replace(re, ".")

	/**** remplace 021 par 21 ****/
	var re = /[*/+-][0]+(\d+)/gi;
	if (calc.match(re)) {
		var m = re.exec(calc);
		var temp=m[1];
		calc = calc.replace(re, temp);
	}

    
    /**** recherche un ^ ****/
  	var re=/\^/g;
	if (calc.match(re)) {                           // test si on a une puissance
		res.value="Use pow(a,b) instead of a^b";
		break;
	}

    /**** remplace pow(2.5) par pow(2,5) ****/
    var formule = document.getElementById('formula-text');  // recupere le handle sur le champ de resultat
    var re=/pow\((\d*).(\d*)\)/;
    var detection=1;
    var index=0;
    while(detection==1 && index<10){
        if (calc.match(re)) {                           // test si on a une puissance
            var m = re.exec(calc);                      // execute l'expression reguliere
            var temp="pow("+m[1]+","+m[2]+")";          // remplace le pow(x.y) par pow(x,y)
            calc = calc.replace(re, temp);
            index = index+1;
        }
        else{
            detection=0;
        }
	}


	
	/**** calcul le resultat ****/
  	var res_temp=eval(calc);    // fait le calcul
    res.value=(Math.round(res_temp*10000000000))/10000000000;   // evite les erreurs de calcul en arrondissant
    

}



function SetModeAngle () {
    // calcul le mode choisit: radian ou degre
    
    var mode=document.getElementById("angle").selectedIndex // radian ou degre?
    widget.setPreferenceForKey(mode, "angle");              // enregistre le choix
    if (mode == 0) {
        DEGREE=Math.PI/180;
    }
    else{
        DEGREE=1;
    }
    var formula = document.getElementById('formula-text');  // recupere le handle sur le champ de la formule
    if(formula.value != 'Enter Formula'){
        CalcExpr(formula.value);    // relance le calcul si c'est pas l'initialisation
    }
    
}
